<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../../../stripe/init.php";    
    include "../../../include/costanti.php";
    include "../../../gUtil/DbManager.php";
    include "../../../classi/ecommerce/Carrello.php";

    session_start();

    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    $impostazioniPagamenti = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPagamenti",1);
    $idCarrello = (!isset($_SESSION["carrello"])) ? 0 : $_SESSION["carrello"];
 
    if($_SESSION["geecomUser_idGruppo"]>0) {
    	$carrello->setGruppoUtente($_SESSION["geecomUser_idGruppo"]);
    }

    $carrello = new Carrello($geecomDb, $idCarrello);
    $carrello->caricaDatiDalDatabase();
    
    \Stripe\Stripe::setApiKey($impostazioniPagamenti["chiaveSegretaStripe"]);
    
    $costoInCentesimi = $carrello->getImportoTotale() * 100;
    
    $paymentIntent = \Stripe\PaymentIntent::create([
        'amount'   => $costoInCentesimi,
        'currency' => 'eur',
    ]);
    
    echo $paymentIntent->client_secret;
